export type LineInfo = {
    listString?: string;
    text: string;
    id?: number;
    level?: number;
};
export type LineWithListInfo = {
    listString?: string;
    text: string;
    i: number;
};
export type Section = {
    text: string;
    content: string;
    listString?: string;
};
export declare class OOXml {
    jObj: {};
    paragraphs: never[];
    text: string;
    fontSize: number;
    origXml: string;
    lineHeight: number;
    suppressHyphenation: boolean;
    constructor(xml: string, { ignoreMultipleFontSizes }?: {
        ignoreMultipleFontSizes?: boolean | undefined;
    });
    getContents(): string;
    setContents(t: string): void;
    getTOC(linesWithListInfo: LineInfo[], text?: string[]): ({
        text: string;
        i: number;
        listString: undefined;
        level?: undefined;
    } | {
        text: string;
        i: number;
        listString: string | undefined;
        level: number | undefined;
    })[];
    getSections(t: LineInfo[], textLines?: string[]): Section[];
    getXml(textWithMarkup?: string): string;
    getXmlBody(textWithMarkup: string): string;
    static decompress(data: Uint8Array): Promise<string | undefined>;
}
export declare function stripCustomTags(e: string): string;
