import { test, expect } from 'vitest';
import { OOXml } from './OOXml';
import { readFileSync } from 'fs';
import { join } from 'path';
import path from 'path';
import lineData from '../test-xml/test.json';
import lineData2 from '../test-xml/lines2.json';
import lineData3 from '../test-xml/lines3.json';
import lineData4 from '../test-xml/kaufvertrag-lines.json';
import lineData5 from '../test-xml/kruess-avv-lines.json';
import { readCompressed } from './compression';
const __dirname = path.dirname(__filename);
test("xml parsing", () => {
    const xmlContent = readFileSync(join(__dirname, '../test-xml/testDoc.xml'), 'utf-8');
    const xml = new OOXml(xmlContent);
    const sections = xml.getSections(lineData);
    console.log(sections.map(it => it.content.length));
    expect(sections[0].listString).toBe("§ 1");
    expect(sections[0].text).toBe("Gegenstand und Dauer des Auftrags");
    expect(sections.findIndex(section => section.text === "Art und Zweck der vorgesehenen Verarbeitung von Daten")).toBeCloseTo(13);
});
test("xml parsing 2", () => {
    const xmlContent = readFileSync(join(__dirname, '../test-xml/doc2.xml'), 'utf-8');
    const xml = new OOXml(xmlContent);
    const sections = xml.getSections(lineData2);
    console.log(sections.map(it => it.content.length));
    const sectNo5index = sections.findIndex(section => section.text.includes("Berichtigung, Einschränkung und Löschung von Auftraggeberdaten; Datenportabilität"));
    expect(sectNo5index).toBeCloseTo(7);
    expect(sections[sectNo5index].content).toContain("Der Auftragnehmer ist verpflichtet");
}, 10000);
test("xml parsing 3", () => {
    const xmlContent = readFileSync(join(__dirname, '../test-xml/doc3.xml'), 'utf-8');
    const xml = new OOXml(xmlContent);
    const sections = xml.getSections(lineData3);
    console.log(sections.map(it => it.content.length));
    expect(sections[4].listString).toBe("§ 5");
    expect(true).toBe(true);
});
test("xml parsing 4", async () => {
    const docXContent = readFileSync(join(__dirname, '../test-xml/kaufvertrag.docx'));
    const xmlContent = await readCompressed(docXContent);
    const xml = new OOXml(xmlContent);
    const sections = xml.getSections(lineData4);
    console.log(sections.map(it => it.content.length));
    expect(sections).toHaveLength(4);
});
test("xml parsing 5", async () => {
    const docXContent = readFileSync(join(__dirname, '../test-xml/kruess-avv.docx'));
    const xmlContent = await readCompressed(docXContent);
    const xml = new OOXml(xmlContent);
    const startTime = performance.now();
    const sections = xml.getSections(lineData5);
    const execTime = performance.now() - startTime;
    console.log(execTime);
    console.log(sections.map(it => it.content.length));
});
