import JSZip from "jszip";
export async function readCompressed(data) {
    var zipLib = new JSZip();
    const zip = await zipLib.loadAsync(data);
    if (zip.file('word/document.xml'))
        return await zip.file('word/document.xml')?.async('string');
    if (zip.file('ppt/presentation.xml'))
        return await zip.file('ppt/presentation.xml')?.async('string');
    if (zip.file('xl/workbook.xml'))
        return await zip.file('xl/workbook.xml')?.async('string');
    throw new Error('neither word/document.xml nor ppt/presentation.xml found nor xl/workbook.xml found');
}
