import { stripCustomTags } from "./OOXml";
export function intersectTexts(plainText, markup) {
    const markupSearchable = stripCustomTags(markup).split("\n").map(l => l.replace(/\W/g, ""));
    plainText = plainText.replace(/\W/g, "");
    let startLine = markupSearchable.findIndex(l => l.length > 50 && (plainText.includes(l) || l.includes(plainText)));
    const endLine = markupSearchable.slice(startLine).findIndex(l => l.length > 50 && !plainText.includes(l) && !l.includes(plainText));
    const resultRaw = markup.split("\n").slice(startLine, endLine === -1 ? undefined : endLine + startLine).join("\n").trim();
    const result = refineResult(resultRaw, plainText);
    return result;
}
function refineResult(markupText, plainText, sliceLen = 40) {
    // Base case: if slice length is too small, return the original text
    if (sliceLen < 5)
        return markupText;
    // Create normalized versions for searching
    const markupNormalized = markupText.replace(/\W/g, "").toLowerCase();
    const plainNormalized = plainText.replace(/\W/g, "").toLowerCase();
    // Get slices from beginning and end of normalized plain text
    const plainStartSlice = plainNormalized.substring(0, Math.min(sliceLen, plainNormalized.length));
    const plainEndSlice = plainNormalized.substring(Math.max(0, plainNormalized.length - sliceLen));
    // Find where these slices appear in the normalized markup
    const startPosNormalized = markupNormalized.indexOf(plainStartSlice);
    const endPosNormalized = markupNormalized.lastIndexOf(plainEndSlice);
    // If both slices were found and they're in the right order
    if (startPosNormalized !== -1 && endPosNormalized !== -1 &&
        startPosNormalized <= endPosNormalized) {
        // Build a mapping from normalized positions to original positions
        const positionMap = [];
        let normalizedPos = 0;
        for (let i = 0; i < markupText.length; i++) {
            if (/\w/i.test(markupText[i])) {
                positionMap[normalizedPos] = i;
                normalizedPos++;
            }
        }
        // Calculate end position, ensuring we don't go out of bounds
        const endNormalizedIndex = Math.min(endPosNormalized + plainEndSlice.length, markupNormalized.length);
        // Get original text positions using the mapping
        const startPosOriginal = positionMap[startPosNormalized];
        const endPosOriginal = endNormalizedIndex >= markupNormalized.length ?
            markupText.length :
            positionMap[endNormalizedIndex - 1] + 1;
        return markupText.substring(startPosOriginal, endPosOriginal);
    }
    // Try with a smaller slice length
    return refineResult(markupText, plainText, Math.floor(sliceLen * 0.75));
}
