import { test, expect } from 'vitest';
import { join } from 'path';
import path from 'path';
import { readFileSync } from 'fs';
import { intersectTexts } from './intersect';
const __dirname = path.dirname(__filename);
test('intersect', () => {
    const plainText = `Der Auftragnehmer setzt vor Beginn der Auftragsverarbeitung die in Anhang 3 (TOMs) projektbezogen vereinbarten technischen und organisatorischen Maßnahmen zum Schutz der Auftraggeberdaten („TOMs“) entsprechend der gesetzlich anwendbaren Anforderungen um. Die im Rahmen der Vereinbarung umgesetzten TOMs stellen die Vertraulichkeit, Integrität, Verfügbarkeit und Belastbarkeit der Systeme und Dienste im Zusammenhang mit der Verarbeitung von Auftraggeberdaten auf Dauer sicher. Der Auftragnehmer dokumentiert die Umsetzung der TOMs schriftlich und ist verpflichtet, dem Auftraggeber vor Beginn der Datenverarbeitung entsprechende Nachweise vorzulegen. Dabei kann der Nachweis der Umsetzung der TOMs auch durch 	Dokumentation nach Ziffer 11(4) dieser Vereinbarung erbracht werden. Soweit die Nachweise die Umsetzung der TOMs ausreichend belegen, akzeptiert der Auftraggeber diese und die Nachweise werden Bestandteil dieser Vereinbarung. Sind die Nachweise nicht ausreichend oder die TOMs nicht ausreichend umgesetzt und weigert sich der Auftragnehmer nachzubessern, ist der Auftraggeber nach Ziffer 16(4) der Vereinbarung zur fristlosen Kündigung aus wichtigem Grund berechtigt.`;
    const markupText = readFileSync(join(__dirname, '../test-xml/kruess-avv-markup.txt'), 'utf-8');
    const result = intersectTexts(plainText, markupText);
    expect(result).toContain("Der Auftragnehmer setzt vor Beginn der");
    expect(result).toContain("aus wichtigem Grund berechtigt.");
});
test('intersect2', () => {
    const plainText = `Der Auftragnehmer setzt vor Beginn der Auftragsverarbeitung die in Anhang 3 (TOMs) projektbezogen vereinbarten technischen und organisatorischen Maßnahmen zum Schutz der Auftraggeberdaten („TOMs“) entsprechend der gesetzlich anwendbaren Anforderungen um. Die im Rahmen der Vereinbarung umgesetzten TOMs stellen die Vertraulichkeit, Integrität, Verfügbarkeit und Belastbarkeit der Systeme und Dienste im Zusammenhang mit der Verarbeitung von Auftraggeberdaten auf Dauer sicher. Der Auftragnehmer dokumentiert die Umsetzung der TOMs schriftlich und ist verpflichtet, dem Auftraggeber vor Beginn der Datenverarbeitung entsprechende Nachweise vorzulegen. Dabei kann der Nachweis der Umsetzung der TOMs auch durch 	Dokumentation nach Ziffer 11(4) dieser Vereinbarung erbracht werden. `;
    const markupText = readFileSync(join(__dirname, '../test-xml/kruess-avv-markup.txt'), 'utf-8');
    const result = intersectTexts(plainText, markupText);
    expect(result).toBe("::style(berschrift2) ::alignboth Der Auftragnehmer setzt vor Beginn der Auftragsverarbeitung die in **Anhang 3(TOMs)projektbezogen** vereinbarten technischen und organisatorischen Maßnahmen zum Schutz der Auftraggeberdaten („**TOMs**“) entsprechend der gesetzlich anwendbaren Anforderungen um. Die im Rahmen der Vereinbarung umgesetzten TOMs stellen die Vertraulichkeit, Integrität, Verfügbarkeit und Belastbarkeit der Systeme und Dienste im Zusammenhang mit der Verarbeitung von Auftraggeberdaten auf Dauer sicher. Der Auftragnehmer dokumentiert die Umsetzung der TOMs schriftlich und ist verpflichtet, dem Auftraggeber vor Beginn der Datenverarbeitung entsprechende Nachweise vorzulegen. Dabei kann der Nachweis der Umsetzung der TOMs auch durch Dokumentation nach Ziffer _Ref449384311(11(4)) dieser Vereinbarung erbracht werden. Soweit die Nachweise die Umsetzung der TOMs ausreichend belegen, akzeptiert der Auftraggeber diese und die Nachweise werden Bestandteil dieser Vereinbarung. Sind die Nachweise nicht ausreichend oder die TOMs nicht ausreichend umgesetzt und weigert sich der Auftragnehmer nachzubessern, ist der Auftraggeber nach Ziffer _Ref459364646(16(4)) der Vereinbarung zur fristlosen Kündigung aus wichtigem Grund berechtigt.");
});
test('intersect3', () => {
    const plainText = `Der Auftragnehmer dokumentiert die Umsetzung der TOMs schriftlich und ist verpflichtet, dem Auftraggeber vor Beginn der Datenverarbeitung entsprechende Nachweise vorzulegen. Dabei kann der Nachweis der Umsetzung der TOMs auch durch 	Dokumentation nach Ziffer 11(4) dieser Vereinbarung erbracht werden. Soweit die Nachweise die Umsetzung der TOMs ausreichend belegen, akzeptiert der Auftraggeber diese und die Nachweise werden Bestandteil dieser Vereinbarung. Sind die Nachweise nicht ausreichend oder die TOMs nicht ausreichend umgesetzt und weigert sich der Auftragnehmer nachzubessern, ist der Auftraggeber nach Ziffer 16(4) der Vereinbarung zur fristlosen Kündigung aus wichtigem Grund berechtigt.`;
    const markupText = readFileSync(join(__dirname, '../test-xml/kruess-avv-markup.txt'), 'utf-8');
    const result = intersectTexts(plainText, markupText);
    expect(result).toMatch(/^Der Auftragnehmer dokumentiert/);
    expect(result).toMatch(/aus wichtigem Grund berechtigt.$/);
});
test('intersect4', () => {
    const plainText = `Der Auftragnehmer setzt vor Beginn der Auftragsverarbeitung die in Anhang 3 (TOMs) projektbezogen vereinbarten technischen und organisatorischen Maßnahmen zum Schutz der Auftraggeberdaten („TOMs“) entsprechend der gesetzlich anwendbaren Anforderungen um.`;
    const markupText = readFileSync(join(__dirname, '../test-xml/kruess-avv-markup.txt'), 'utf-8');
    const result = intersectTexts(plainText, markupText);
    expect(result).toMatch(/^Der Auftragnehmer setzt vor Beginn/);
    expect(result).toMatch(/anwendbaren Anforderungen um$/);
});
