import { test, expect } from "vitest";
import { OOXml as OOXML } from "./OOXml";
import { XMLValidator } from "fast-xml-parser";
const xml = `<?xml version="1.0" standalone="yes"?>
<?mso-application progid="Word.Document"?>
<pkg:package xmlns:pkg="http://schemas.microsoft.com/office/2006/xmlPackage">
    <pkg:part pkg:name='/_rels/.rels' pkg:contentType='application/vnd.openxmlformats-package.relationships+xml' pkg:padding='512'><pkg:xmlData><Relationships xmlns='http://schemas.openxmlformats.org/package/2006/relationships'><Relationship Id='rId1' Type='http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument' Target='word/document.xml'/></Relationships></pkg:xmlData></pkg:part>
    <pkg:part pkg:name="/word/document.xml"
        pkg:contentType="application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml">
        <pkg:xmlData>
            <w:document >
                <w:body>
                    <w:p w14:paraId="04945870" w14:textId="77777777" w:rsidR="00C172F2"
                        w:rsidRDefault="00C172F2" w:rsidP="00C172F2">
                        <w:pPr>
                            <w:pStyle w:val="ESLegal2" />
                            <w:suppressAutoHyphens />
                        </w:pPr>
                        <w:bookmarkStart w:id="0" w:name="_Ref133313657" />
                        <w:r>
                            <w:t xml:space="preserve">Ansprüche des Käufers gegen </w:t>
                        </w:r>
                        <w:r>
                            <w:rPr>
                                <w:color w:val="008FA0" />
                            </w:rPr>
                            <w:t>die Verkäufer</w:t>
                        </w:r>
                        <w:r>
                            <w:t xml:space="preserve"> aus der Verletzung einer Verkäufergarantie sind der Höhe nach auf </w:t>
                        </w:r>
                        <w:r>
                            <w:rPr>
                                <w:color w:val="008FA0" />
                            </w:rPr>
                            <w:t>50</w:t>
                        </w:r>
                        <w:r>
                            <w:t> % des Kaufpreises begrenzt.</w:t>
                        </w:r>
                        <w:bookmarkEnd w:id="0" />
                    </w:p>
                    <w:p w14:paraId="4A118386" w14:textId="77777777" w:rsidR="00C172F2"
                        w:rsidRDefault="00C172F2" w:rsidP="00C172F2">
                        <w:pPr>
                            <w:pStyle w:val="ESLegal2" />
                            <w:suppressAutoHyphens />
                        </w:pPr>
                        <w:r>
                            <w:t xml:space="preserve">Ziffern </w:t>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="begin" />
                        </w:r>
                        <w:r>
                            <w:instrText xml:space="preserve"> REF _Ref133313651 \r \h </w:instrText>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="separate" />
                        </w:r>
                        <w:r>
                            <w:t>6.6</w:t>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="end" />
                        </w:r>
                        <w:r>
                            <w:t xml:space="preserve"> und </w:t>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="begin" />
                        </w:r>
                        <w:r>
                            <w:instrText xml:space="preserve"> REF _Ref133313657 \r \h </w:instrText>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="separate" />
                        </w:r>
                        <w:r>
                            <w:t>6.7</w:t>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="end" />
                        </w:r>
                        <w:r>
                            <w:t xml:space="preserve"> finden keine Anwendung auf die Garantien unter Ziffer </w:t>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="begin" />
                        </w:r>
                        <w:r>
                            <w:instrText xml:space="preserve"> REF _Ref229749799 \r \h </w:instrText>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="separate" />
                        </w:r>
                        <w:r>
                            <w:t>7.1</w:t>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="end" />
                        </w:r>
                        <w:r>
                            <w:t xml:space="preserve"> und </w:t>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="begin" />
                        </w:r>
                        <w:r>
                            <w:instrText xml:space="preserve"> REF _Ref133313739 \r \h </w:instrText>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="separate" />
                        </w:r>
                        <w:r>
                            <w:t>7.2.1</w:t>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="end" />
                        </w:r>
                        <w:r>
                            <w:t>. Die Haftung für die in diesen Bestimmungen übernommenen
                                Verkäufergarantien ist auf die Höhe des gezahlten Kaufpreises
                                beschränkt.</w:t>
                        </w:r>
                    </w:p>
                    <w:p w14:paraId="1CEF866C" w14:textId="77777777" w:rsidR="00C172F2"
                        w:rsidRPr="00CB5A75" w:rsidRDefault="00C172F2" w:rsidP="00C172F2">
                        <w:pPr>
                            <w:pStyle w:val="ESLegal2" />
                            <w:suppressAutoHyphens />
                        </w:pPr>
                        <w:r>
                            <w:t xml:space="preserve">Die Parteien halten klarstellend fest, dass der Käufer bei gleichzeitiger Verletzung mehrerer Verkäufergarantien durch denselben Sachverhalt einen Schaden nur einmal geltend machen kann (kein sog. </w:t>
                        </w:r>
                        <w:r w:rsidRPr="00E62F86">
                            <w:rPr>
                                <w:i />
                            </w:rPr>
                            <w:t>double dip</w:t>
                        </w:r>
                        <w:r>
                            <w:t xml:space="preserve">). Gleiches gilt klarstellend, falls eine sich aus den Ziffern </w:t>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="begin" />
                        </w:r>
                        <w:r>
                            <w:instrText xml:space="preserve"> REF _Ref462596241 \r \h </w:instrText>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="separate" />
                        </w:r>
                        <w:r>
                            <w:t>9</w:t>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="end" />
                        </w:r>
                        <w:r>
                            <w:t xml:space="preserve"> oder </w:t>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="begin" />
                        </w:r>
                        <w:r>
                            <w:instrText xml:space="preserve"> REF _Ref527951776 \r \h </w:instrText>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="separate" />
                        </w:r>
                        <w:r>
                            <w:t>10</w:t>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="end" />
                        </w:r>
                        <w:r>
                            <w:t xml:space="preserve"> ergebende Freistellungsverpflichtung gleichzeitig die Verletzung einer Verkäufergarantie darstellen sollte, wobei dann Ansprüche aus Ziffern </w:t>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="begin" />
                        </w:r>
                        <w:r>
                            <w:instrText xml:space="preserve"> REF _Ref462596241 \r \h </w:instrText>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="separate" />
                        </w:r>
                        <w:r>
                            <w:t>9</w:t>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="end" />
                        </w:r>
                        <w:r>
                            <w:t xml:space="preserve"> oder </w:t>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="begin" />
                        </w:r>
                        <w:r>
                            <w:instrText xml:space="preserve"> REF _Ref527951776 \r \h </w:instrText>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="separate" />
                        </w:r>
                        <w:r>
                            <w:t>10</w:t>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="end" />
                        </w:r>
                        <w:r>
                            <w:t xml:space="preserve"> vorrangig sind.</w:t>
                        </w:r>
                    </w:p>
                    <w:p w14:paraId="4D9867F3" w14:textId="77777777" w:rsidR="00000000"
                        w:rsidRDefault="00C172F2" />
                    <w:sectPr w:rsidR="00000000">
                        <w:pgSz w:w="12240" w:h="15840" />
                        <w:pgMar w:top="1417" w:right="1417" w:bottom="1134" w:left="1417"
                            w:header="720" w:footer="720" w:gutter="0" />
                        <w:cols w:space="720" />
                    </w:sectPr>
                </w:body>
            </w:document>
        </pkg:xmlData>
    </pkg:part>
</pkg:package>
`;
const xml2 = `<pkg:package xmlns:pkg="http://schemas.microsoft.com/office/2006/xmlPackage">
<pkg:part pkg:name="/_rels/.rels"
    pkg:contentType="application/vnd.openxmlformats-package.relationships+xml" pkg:padding="512">
    <pkg:xmlData>
        <Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships">
            <Relationship Id="selectedAnswers"
                Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/json"
                Target="lawlift/selectedAnswers.json" />
            <Relationship Id="document"
                Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/json"
                Target="lawlift/document.json" />
            <Relationship Id="rId1"
                Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument"
                Target="word/document.xml" />
        </Relationships>
    </pkg:xmlData>
</pkg:part>
<pkg:part pkg:name="/word/document.xml"
    pkg:contentType="application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml">
    <pkg:xmlData>
        <w:document
            xmlns:wpc="http://schemas.microsoft.com/office/word/2010/wordprocessingCanvas"
            xmlns:cx="http://schemas.microsoft.com/office/drawing/2014/chartex"
            xmlns:cx1="http://schemas.microsoft.com/office/drawing/2015/9/8/chartex"
            xmlns:cx2="http://schemas.microsoft.com/office/drawing/2015/10/21/chartex"
            xmlns:cx3="http://schemas.microsoft.com/office/drawing/2016/5/9/chartex"
            xmlns:cx4="http://schemas.microsoft.com/office/drawing/2016/5/10/chartex"
            xmlns:cx5="http://schemas.microsoft.com/office/drawing/2016/5/11/chartex"
            xmlns:cx6="http://schemas.microsoft.com/office/drawing/2016/5/12/chartex"
            xmlns:cx7="http://schemas.microsoft.com/office/drawing/2016/5/13/chartex"
            xmlns:cx8="http://schemas.microsoft.com/office/drawing/2016/5/14/chartex"
            xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006"
            xmlns:aink="http://schemas.microsoft.com/office/drawing/2016/ink"
            xmlns:am3d="http://schemas.microsoft.com/office/drawing/2017/model3d"
            xmlns:o="urn:schemas-microsoft-com:office:office"
            xmlns:oel="http://schemas.microsoft.com/office/2019/extlst"
            xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships"
            xmlns:m="http://schemas.openxmlformats.org/officeDocument/2006/math"
            xmlns:v="urn:schemas-microsoft-com:vml"
            xmlns:wp14="http://schemas.microsoft.com/office/word/2010/wordprocessingDrawing"
            xmlns:wp="http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing"
            xmlns:w10="urn:schemas-microsoft-com:office:word"
            xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main"
            xmlns:w14="http://schemas.microsoft.com/office/word/2010/wordml"
            xmlns:w15="http://schemas.microsoft.com/office/word/2012/wordml"
            xmlns:w16cex="http://schemas.microsoft.com/office/word/2018/wordml/cex"
            xmlns:w16cid="http://schemas.microsoft.com/office/word/2016/wordml/cid"
            xmlns:w16="http://schemas.microsoft.com/office/word/2018/wordml"
            xmlns:w16sdtdh="http://schemas.microsoft.com/office/word/2020/wordml/sdtdatahash"
            xmlns:w16se="http://schemas.microsoft.com/office/word/2015/wordml/symex"
            xmlns:wpg="http://schemas.microsoft.com/office/word/2010/wordprocessingGroup"
            xmlns:wpi="http://schemas.microsoft.com/office/word/2010/wordprocessingInk"
            xmlns:wne="http://schemas.microsoft.com/office/word/2006/wordml"
            xmlns:wps="http://schemas.microsoft.com/office/word/2010/wordprocessingShape"
            mc:Ignorable="w14 w15 w16se w16cid w16 w16cex w16sdtdh wp14">
            <w:body>
                <w:p w14:paraId="0C930BE1" w14:textId="77777777" w:rsidR="00E32C69"
                    w:rsidRDefault="00E32C69" w:rsidP="00E32C69">
                    <w:pPr>
                        <w:pStyle w:val="ESLegal3" />
                        <w:suppressAutoHyphens />
                    </w:pPr>
                    <w:r>
                        <w:t>der Erwerb von Aktien börsennotierter Gesellschaften in Höhe von
                            höchstens 2,9 % des jeweiligen Grundkapitals zu Zwecken der
                            Kapitalanlage;</w:t>
                    </w:r>
                </w:p>
                <w:p w14:paraId="003B71B6" w14:textId="77777777" w:rsidR="00E32C69"
                    w:rsidRDefault="00E32C69" w:rsidP="00E32C69">
                    <w:pPr>
                        <w:pStyle w:val="ESLegal3" />
                        <w:suppressAutoHyphens />
                    </w:pPr>
                    <w:bookmarkStart w:id="0" w:name="_Ref138212150" />
                    <w:r>
                        <w:t xml:space="preserve">das Halten oder Erwerben einer Beteiligung sowie die Aufnahme oder Fortsetzung einer Tätigkeit, bei welchen der </w:t>
                    </w:r>
                    <w:r w:rsidRPr="00E62F86">
                        <w:rPr>
                            <w:color w:val="008FA0" />
                        </w:rPr>
                        <w:t>jeweilige</w:t>
                    </w:r>
                    <w:r>
                        <w:t xml:space="preserve"> Verkäufer nachweist, dass die Nutzung wettbewerblich relevanter Kenntnisse der Zielgesellschaft ausgeschlossen ist; und</w:t>
                    </w:r>
                    <w:bookmarkEnd w:id="0" />
                </w:p>
                <w:p w14:paraId="5BB2B14B" w14:textId="77777777" w:rsidR="00000000"
                    w:rsidRDefault="00E32C69" />
                <w:sectPr w:rsidR="00000000">
                    <w:pgSz w:w="12240" w:h="15840" />
                    <w:pgMar w:top="1417" w:right="1417" w:bottom="1134" w:left="1417"
                        w:header="720" w:footer="720" w:gutter="0" />
                    <w:cols w:space="720" />
                </w:sectPr>
            </w:body>
        </w:document>
    </pkg:xmlData>
</pkg:part>
</pkg:package>`;
const xml3 = `<pkg:package xmlns:pkg="http://schemas.microsoft.com/office/2006/xmlPackage">
<pkg:part pkg:name="/_rels/.rels"
    pkg:contentType="application/vnd.openxmlformats-package.relationships+xml" pkg:padding="512">
    <pkg:xmlData>
        <Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships">
            <Relationship Id="selectedAnswers"
                Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/json"
                Target="lawlift/selectedAnswers.json" />
            <Relationship Id="document"
                Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/json"
                Target="lawlift/document.json" />
            <Relationship Id="rId1"
                Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument"
                Target="word/document.xml" />
        </Relationships>
    </pkg:xmlData>
</pkg:part>
<pkg:part pkg:name="/word/document.xml"
    pkg:contentType="application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml">
    <pkg:xmlData>
        <w:document
            xmlns:wpc="http://schemas.microsoft.com/office/word/2010/wordprocessingCanvas"
            xmlns:cx="http://schemas.microsoft.com/office/drawing/2014/chartex"
            xmlns:cx1="http://schemas.microsoft.com/office/drawing/2015/9/8/chartex"
            xmlns:cx2="http://schemas.microsoft.com/office/drawing/2015/10/21/chartex"
            xmlns:cx3="http://schemas.microsoft.com/office/drawing/2016/5/9/chartex"
            xmlns:cx4="http://schemas.microsoft.com/office/drawing/2016/5/10/chartex"
            xmlns:cx5="http://schemas.microsoft.com/office/drawing/2016/5/11/chartex"
            xmlns:cx6="http://schemas.microsoft.com/office/drawing/2016/5/12/chartex"
            xmlns:cx7="http://schemas.microsoft.com/office/drawing/2016/5/13/chartex"
            xmlns:cx8="http://schemas.microsoft.com/office/drawing/2016/5/14/chartex"
            xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006"
            xmlns:aink="http://schemas.microsoft.com/office/drawing/2016/ink"
            xmlns:am3d="http://schemas.microsoft.com/office/drawing/2017/model3d"
            xmlns:o="urn:schemas-microsoft-com:office:office"
            xmlns:oel="http://schemas.microsoft.com/office/2019/extlst"
            xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships"
            xmlns:m="http://schemas.openxmlformats.org/officeDocument/2006/math"
            xmlns:v="urn:schemas-microsoft-com:vml"
            xmlns:wp14="http://schemas.microsoft.com/office/word/2010/wordprocessingDrawing"
            xmlns:wp="http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing"
            xmlns:w10="urn:schemas-microsoft-com:office:word"
            xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main"
            xmlns:w14="http://schemas.microsoft.com/office/word/2010/wordml"
            xmlns:w15="http://schemas.microsoft.com/office/word/2012/wordml"
            xmlns:w16cex="http://schemas.microsoft.com/office/word/2018/wordml/cex"
            xmlns:w16cid="http://schemas.microsoft.com/office/word/2016/wordml/cid"
            xmlns:w16="http://schemas.microsoft.com/office/word/2018/wordml"
            xmlns:w16sdtdh="http://schemas.microsoft.com/office/word/2020/wordml/sdtdatahash"
            xmlns:w16se="http://schemas.microsoft.com/office/word/2015/wordml/symex"
            xmlns:wpg="http://schemas.microsoft.com/office/word/2010/wordprocessingGroup"
            xmlns:wpi="http://schemas.microsoft.com/office/word/2010/wordprocessingInk"
            xmlns:wne="http://schemas.microsoft.com/office/word/2006/wordml"
            xmlns:wps="http://schemas.microsoft.com/office/word/2010/wordprocessingShape"
            mc:Ignorable="w14 w15 w16se w16cid w16 w16cex w16sdtdh wp14">
            <w:body>
                <w:p w14:paraId="3615F771" w14:textId="77777777" w:rsidR="004F50B6"
                    w:rsidRDefault="004F50B6" w:rsidP="004F50B6">
                    <w:pPr>
                        <w:pStyle w:val="ESLegal2" />
                        <w:suppressAutoHyphens />
                    </w:pPr>
                    <w:r>
                        <w:t>Ausgenommen von diesem Wettbewerbsverbot ist</w:t>
                    </w:r>
                </w:p>
                <w:p w14:paraId="03C2865E" w14:textId="77777777" w:rsidR="004F50B6"
                    w:rsidRDefault="004F50B6" w:rsidP="004F50B6">
                    <w:pPr>
                        <w:pStyle w:val="ESLegal3" />
                        <w:suppressAutoHyphens />
                    </w:pPr>
                    <w:r>
                        <w:t>der Erwerb von Aktien börsennotierter Gesellschaften in Höhe von
                            höchstens 2,9 % des jeweiligen Grundkapitals zu Zwecken der
                            Kapitalanlage;</w:t>
                    </w:r>
                </w:p>
                <w:p w14:paraId="58A96F3B" w14:textId="77777777" w:rsidR="004F50B6"
                    w:rsidRDefault="004F50B6" w:rsidP="004F50B6">
                    <w:pPr>
                        <w:pStyle w:val="ESLegal3" />
                        <w:suppressAutoHyphens />
                    </w:pPr>
                    <w:bookmarkStart w:id="0" w:name="_Ref138212150" />
                    <w:r>
                        <w:t xml:space="preserve">das Halten oder Erwerben einer Beteiligung sowie die Aufnahme oder Fortsetzung einer Tätigkeit, bei welchen der </w:t>
                    </w:r>
                    <w:r w:rsidRPr="00E62F86">
                        <w:rPr>
                            <w:color w:val="008FA0" />
                        </w:rPr>
                        <w:t>jeweilige</w:t>
                    </w:r>
                    <w:r>
                        <w:t xml:space="preserve"> Verkäufer nachweist, dass die Nutzung wettbewerblich relevanter Kenntnisse der Zielgesellschaft ausgeschlossen ist; und</w:t>
                    </w:r>
                    <w:bookmarkEnd w:id="0" />
                </w:p>
                <w:p w14:paraId="54E5A3B7" w14:textId="77777777" w:rsidR="00000000"
                    w:rsidRDefault="004F50B6" />
                <w:sectPr w:rsidR="00000000">
                    <w:pgSz w:w="12240" w:h="15840" />
                    <w:pgMar w:top="1417" w:right="1417" w:bottom="1134" w:left="1417"
                        w:header="720" w:footer="720" w:gutter="0" />
                    <w:cols w:space="720" />
                </w:sectPr>
            </w:body>
        </w:document>
    </pkg:xmlData>
</pkg:part>
</pkg:package>`;
const xml4 = `<pkg:package xmlns:pkg="http://schemas.microsoft.com/office/2006/xmlPackage">
<pkg:part pkg:name="/_rels/.rels"
    pkg:contentType="application/vnd.openxmlformats-package.relationships+xml" pkg:padding="512">
    <pkg:xmlData>
        <Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships">
            <Relationship Id="selectedAnswers"
                Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/json"
                Target="lawlift/selectedAnswers.json" />
            <Relationship Id="document"
                Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/json"
                Target="lawlift/document.json" />
            <Relationship Id="rId1"
                Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument"
                Target="word/document.xml" />
        </Relationships>
    </pkg:xmlData>
</pkg:part>
<pkg:part pkg:name="/word/document.xml"
    pkg:contentType="application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml">
    <pkg:xmlData>
        <w:document
            xmlns:wpc="http://schemas.microsoft.com/office/word/2010/wordprocessingCanvas"
            xmlns:cx="http://schemas.microsoft.com/office/drawing/2014/chartex"
            xmlns:cx1="http://schemas.microsoft.com/office/drawing/2015/9/8/chartex"
            xmlns:cx2="http://schemas.microsoft.com/office/drawing/2015/10/21/chartex"
            xmlns:cx3="http://schemas.microsoft.com/office/drawing/2016/5/9/chartex"
            xmlns:cx4="http://schemas.microsoft.com/office/drawing/2016/5/10/chartex"
            xmlns:cx5="http://schemas.microsoft.com/office/drawing/2016/5/11/chartex"
            xmlns:cx6="http://schemas.microsoft.com/office/drawing/2016/5/12/chartex"
            xmlns:cx7="http://schemas.microsoft.com/office/drawing/2016/5/13/chartex"
            xmlns:cx8="http://schemas.microsoft.com/office/drawing/2016/5/14/chartex"
            xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006"
            xmlns:aink="http://schemas.microsoft.com/office/drawing/2016/ink"
            xmlns:am3d="http://schemas.microsoft.com/office/drawing/2017/model3d"
            xmlns:o="urn:schemas-microsoft-com:office:office"
            xmlns:oel="http://schemas.microsoft.com/office/2019/extlst"
            xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships"
            xmlns:m="http://schemas.openxmlformats.org/officeDocument/2006/math"
            xmlns:v="urn:schemas-microsoft-com:vml"
            xmlns:wp14="http://schemas.microsoft.com/office/word/2010/wordprocessingDrawing"
            xmlns:wp="http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing"
            xmlns:w10="urn:schemas-microsoft-com:office:word"
            xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main"
            xmlns:w14="http://schemas.microsoft.com/office/word/2010/wordml"
            xmlns:w15="http://schemas.microsoft.com/office/word/2012/wordml"
            xmlns:w16cex="http://schemas.microsoft.com/office/word/2018/wordml/cex"
            xmlns:w16cid="http://schemas.microsoft.com/office/word/2016/wordml/cid"
            xmlns:w16="http://schemas.microsoft.com/office/word/2018/wordml"
            xmlns:w16sdtdh="http://schemas.microsoft.com/office/word/2020/wordml/sdtdatahash"
            xmlns:w16se="http://schemas.microsoft.com/office/word/2015/wordml/symex"
            xmlns:wpg="http://schemas.microsoft.com/office/word/2010/wordprocessingGroup"
            xmlns:wpi="http://schemas.microsoft.com/office/word/2010/wordprocessingInk"
            xmlns:wne="http://schemas.microsoft.com/office/word/2006/wordml"
            xmlns:wps="http://schemas.microsoft.com/office/word/2010/wordprocessingShape"
            mc:Ignorable="w14 w15 w16se w16cid w16 w16cex w16sdtdh wp14">
            <w:body>
                <w:p w14:paraId="3F3B6B8E" w14:textId="77777777" w:rsidR="00BF698C"
                    w:rsidRDefault="00BF698C" w:rsidP="00BF698C">
                    <w:pPr>
                        <w:pStyle w:val="ESLegal3" />
                        <w:suppressAutoHyphens />
                    </w:pPr>
                    <w:bookmarkStart w:id="0" w:name="_Ref133327951" />
                    <w:r>
                        <w:t xml:space="preserve">das Halten einer Beteiligung an sowie die Ausübung einer Organstellung in den in </w:t>
                    </w:r>
                    <w:r w:rsidRPr="00E62F86">
                        <w:rPr>
                            <w:rFonts w:asciiTheme="majorHAnsi" w:hAnsiTheme="majorHAnsi" />
                        </w:rPr>
                        <w:t>Anlage</w:t>
                    </w:r>
                    <w:r w:rsidRPr="00BA2B92">
                        <w:rPr>
                            <w:rFonts w:asciiTheme="majorHAnsi" w:hAnsiTheme="majorHAnsi"
                                w:cstheme="majorHAnsi" />
                            <w:bCs />
                        </w:rPr>
                        <w:t> </w:t>
                    </w:r>
                    <w:r w:rsidRPr="00BA2B92">
                        <w:rPr>
                            <w:rFonts w:asciiTheme="majorHAnsi" w:hAnsiTheme="majorHAnsi"
                                w:cstheme="majorHAnsi" />
                            <w:bCs />
                        </w:rPr>
                        <w:fldChar w:fldCharType="begin" />
                    </w:r>
                    <w:r w:rsidRPr="00BA2B92">
                        <w:rPr>
                            <w:rFonts w:asciiTheme="majorHAnsi" w:hAnsiTheme="majorHAnsi"
                                w:cstheme="majorHAnsi" />
                            <w:bCs />
                        </w:rPr>
                        <w:instrText xml:space="preserve"> REF _Ref133327951 \r \h </w:instrText>
                    </w:r>
                    <w:r w:rsidRPr="00BA2B92">
                        <w:rPr>
                            <w:rFonts w:asciiTheme="majorHAnsi" w:hAnsiTheme="majorHAnsi"
                                w:cstheme="majorHAnsi" />
                            <w:bCs />
                        </w:rPr>
                    </w:r>
                    <w:r w:rsidRPr="00BA2B92">
                        <w:rPr>
                            <w:rFonts w:asciiTheme="majorHAnsi" w:hAnsiTheme="majorHAnsi"
                                w:cstheme="majorHAnsi" />
                            <w:bCs />
                        </w:rPr>
                        <w:fldChar w:fldCharType="separate" />
                    </w:r>
                    <w:r>
                        <w:rPr>
                            <w:rFonts w:asciiTheme="majorHAnsi" w:hAnsiTheme="majorHAnsi"
                                w:cstheme="majorHAnsi" />
                            <w:bCs />
                        </w:rPr>
                        <w:t>12.2.3</w:t>
                    </w:r>
                    <w:r w:rsidRPr="00BA2B92">
                        <w:rPr>
                            <w:rFonts w:asciiTheme="majorHAnsi" w:hAnsiTheme="majorHAnsi"
                                w:cstheme="majorHAnsi" />
                            <w:bCs />
                        </w:rPr>
                        <w:fldChar w:fldCharType="end" />
                    </w:r>
                    <w:r>
                        <w:rPr>
                            <w:bCs />
                        </w:rPr>
                        <w:fldChar w:fldCharType="begin" />
                    </w:r>
                    <w:r>
                        <w:rPr>
                            <w:bCs />
                        </w:rPr>
                        <w:instrText xml:space="preserve"> TC "</w:instrText>
                    </w:r>
                    <w:r w:rsidRPr="00BA2B92">
                        <w:rPr>
                            <w:bCs />
                        </w:rPr>
                        <w:instrText xml:space="preserve"> </w:instrText>
                    </w:r>
                    <w:bookmarkStart w:id="1" w:name="_Toc133330445" />
                    <w:r w:rsidRPr="00BA2B92">
                        <w:rPr>
                            <w:bCs />
                        </w:rPr>
                        <w:instrText>Anlage</w:instrText>
                    </w:r>
                    <w:r>
                        <w:rPr>
                            <w:bCs />
                        </w:rPr>
                        <w:instrText> </w:instrText>
                    </w:r>
                    <w:r>
                        <w:rPr>
                            <w:bCs />
                        </w:rPr>
                        <w:fldChar w:fldCharType="begin" />
                    </w:r>
                    <w:r>
                        <w:rPr>
                            <w:bCs />
                        </w:rPr>
                        <w:instrText xml:space="preserve"> REF _Ref133327951 \r \h </w:instrText>
                    </w:r>
                    <w:r>
                        <w:rPr>
                            <w:bCs />
                        </w:rPr>
                    </w:r>
                    <w:r>
                        <w:rPr>
                            <w:bCs />
                        </w:rPr>
                        <w:fldChar w:fldCharType="separate" />
                    </w:r>
                    <w:r>
                        <w:rPr>
                            <w:bCs />
                        </w:rPr>
                        <w:instrText>12.2.3</w:instrText>
                    </w:r>
                    <w:r>
                        <w:rPr>
                            <w:bCs />
                        </w:rPr>
                        <w:fldChar w:fldCharType="end" />
                    </w:r>
                    <w:r>
                        <w:rPr>
                            <w:bCs />
                        </w:rPr>
                        <w:instrText>: Verkäufergesellschaften</w:instrText>
                    </w:r>
                    <w:bookmarkEnd w:id="1" />
                    <w:r>
                        <w:rPr>
                            <w:bCs />
                        </w:rPr>
                        <w:instrText xml:space="preserve">"\f C\I "1" </w:instrText>
                    </w:r>
                    <w:r>
                        <w:rPr>
                            <w:bCs />
                        </w:rPr>
                        <w:fldChar w:fldCharType="end" />
                    </w:r>
                    <w:r>
                        <w:t xml:space="preserve"> genannten Gesellschaften, solange diese nur die in </w:t>
                    </w:r>
                    <w:r w:rsidRPr="00E62F86">
                        <w:t>Anlage</w:t>
                    </w:r>
                    <w:r>
                        <w:rPr>
                            <w:bCs />
                        </w:rPr>
                        <w:t> </w:t>
                    </w:r>
                    <w:r>
                        <w:rPr>
                            <w:bCs />
                        </w:rPr>
                        <w:fldChar w:fldCharType="begin" />
                    </w:r>
                    <w:r>
                        <w:rPr>
                            <w:bCs />
                        </w:rPr>
                        <w:instrText xml:space="preserve"> REF _Ref133327951 \r \h </w:instrText>
                    </w:r>
                    <w:r>
                        <w:rPr>
                            <w:bCs />
                        </w:rPr>
                    </w:r>
                    <w:r>
                        <w:rPr>
                            <w:bCs />
                        </w:rPr>
                        <w:fldChar w:fldCharType="separate" />
                    </w:r>
                    <w:r>
                        <w:rPr>
                            <w:bCs />
                        </w:rPr>
                        <w:t>12.2.3</w:t>
                    </w:r>
                    <w:r>
                        <w:rPr>
                            <w:bCs />
                        </w:rPr>
                        <w:fldChar w:fldCharType="end" />
                    </w:r>
                    <w:r>
                        <w:rPr>
                            <w:bCs />
                        </w:rPr>
                        <w:t xml:space="preserve"> </w:t>
                    </w:r>
                    <w:r>
                        <w:t>jeweils konkret beschriebene Geschäftstätigkeit ausüben.</w:t>
                    </w:r>
                    <w:bookmarkEnd w:id="0" />
                </w:p>
                <w:p w14:paraId="5C3582F8" w14:textId="77777777" w:rsidR="00000000"
                    w:rsidRDefault="00BF698C" />
                <w:sectPr w:rsidR="00000000">
                    <w:pgSz w:w="12240" w:h="15840" />
                    <w:pgMar w:top="1417" w:right="1417" w:bottom="1134" w:left="1417"
                        w:header="720" w:footer="720" w:gutter="0" />
                    <w:cols w:space="720" />
                </w:sectPr>
            </w:body>
        </w:document>
    </pkg:xmlData>
</pkg:part>
</pkg:package>`;
const xmlWithCommentAndTermDef2 = `<?xml version="1.0" standalone="yes"?>
<?mso-application progid="Word.Document"?>
<pkg:package xmlns:pkg="http://schemas.microsoft.com/office/2006/xmlPackage">
    <pkg:part pkg:name="/_rels/.rels"
        pkg:contentType="application/vnd.openxmlformats-package.relationships+xml" pkg:padding="512">
        <pkg:xmlData>
            <Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships">
                <Relationship Id="selectedAnswers"
                    Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/json"
                    Target="lawlift/selectedAnswers.json" />
                <Relationship Id="document"
                    Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/json"
                    Target="lawlift/document.json" />
                <Relationship Id="rId1"
                    Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument"
                    Target="word/document.xml" />
            </Relationships>
        </pkg:xmlData>
    </pkg:part>
    <pkg:part pkg:name="/word/document.xml"
        pkg:contentType="application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml">
        <pkg:xmlData>
            <w:document
                xmlns:wpc="http://schemas.microsoft.com/office/word/2010/wordprocessingCanvas"
                xmlns:cx="http://schemas.microsoft.com/office/drawing/2014/chartex"
                xmlns:cx1="http://schemas.microsoft.com/office/drawing/2015/9/8/chartex"
                xmlns:cx2="http://schemas.microsoft.com/office/drawing/2015/10/21/chartex"
                xmlns:cx3="http://schemas.microsoft.com/office/drawing/2016/5/9/chartex"
                xmlns:cx4="http://schemas.microsoft.com/office/drawing/2016/5/10/chartex"
                xmlns:cx5="http://schemas.microsoft.com/office/drawing/2016/5/11/chartex"
                xmlns:cx6="http://schemas.microsoft.com/office/drawing/2016/5/12/chartex"
                xmlns:cx7="http://schemas.microsoft.com/office/drawing/2016/5/13/chartex"
                xmlns:cx8="http://schemas.microsoft.com/office/drawing/2016/5/14/chartex"
                xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006"
                xmlns:aink="http://schemas.microsoft.com/office/drawing/2016/ink"
                xmlns:am3d="http://schemas.microsoft.com/office/drawing/2017/model3d"
                xmlns:o="urn:schemas-microsoft-com:office:office"
                xmlns:oel="http://schemas.microsoft.com/office/2019/extlst"
                xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships"
                xmlns:m="http://schemas.openxmlformats.org/officeDocument/2006/math"
                xmlns:v="urn:schemas-microsoft-com:vml"
                xmlns:wp14="http://schemas.microsoft.com/office/word/2010/wordprocessingDrawing"
                xmlns:wp="http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing"
                xmlns:w10="urn:schemas-microsoft-com:office:word"
                xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main"
                xmlns:w14="http://schemas.microsoft.com/office/word/2010/wordml"
                xmlns:w15="http://schemas.microsoft.com/office/word/2012/wordml"
                xmlns:w16cex="http://schemas.microsoft.com/office/word/2018/wordml/cex"
                xmlns:w16cid="http://schemas.microsoft.com/office/word/2016/wordml/cid"
                xmlns:w16="http://schemas.microsoft.com/office/word/2018/wordml"
                xmlns:w16sdtdh="http://schemas.microsoft.com/office/word/2020/wordml/sdtdatahash"
                xmlns:w16se="http://schemas.microsoft.com/office/word/2015/wordml/symex"
                xmlns:wpg="http://schemas.microsoft.com/office/word/2010/wordprocessingGroup"
                xmlns:wpi="http://schemas.microsoft.com/office/word/2010/wordprocessingInk"
                xmlns:wne="http://schemas.microsoft.com/office/word/2006/wordml"
                xmlns:wps="http://schemas.microsoft.com/office/word/2010/wordprocessingShape"
                mc:Ignorable="w14 w15 w16se w16cid w16 w16cex w16sdtdh wp14">
                <w:body>
                    <w:p w14:paraId="61DE3434" w14:textId="77777777" w:rsidR="005A0522"
                        w:rsidRDefault="005A0522" w:rsidP="005A0522">
                        <w:pPr>
                            <w:pStyle w:val="ESLegal2" />
                            <w:suppressAutoHyphens />
                        </w:pPr>
                        <w:bookmarkStart w:id="0" w:name="_Ref450615844" />
                        <w:r>
                            <w:rPr>
                                <w:color w:val="008FA0" />
                            </w:rPr>
                            <w:t>Die Verkäufer</w:t>
                        </w:r>
                        <w:r>
                            <w:t xml:space="preserve"> </w:t>
                        </w:r>
                        <w:commentRangeStart w:id="1" />
                        <w:r>
                            <w:t xml:space="preserve">und die Verkäufergesellschafter </w:t>
                        </w:r>
                        <w:commentRangeEnd w:id="1" />
                        <w:r>
                            <w:rPr>
                                <w:rStyle w:val="Kommentarzeichen" />
                            </w:rPr>
                            <w:commentReference w:id="1" />
                        </w:r>
                        <w:r>
                            <w:t>verpflichten sich, jeweils unabhängig und jeder für sich
                                (nachfolgen jeweils einzeln ein „</w:t>
                        </w:r>
                        <w:r w:rsidRPr="00BA2B92">
                            <w:rPr>
                                <w:rFonts w:asciiTheme="majorHAnsi" w:hAnsiTheme="majorHAnsi"
                                    w:cstheme="majorHAnsi" />
                            </w:rPr>
                            <w:t>Verpflichteter</w:t>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="begin" />
                        </w:r>
                        <w:r>
                            <w:instrText xml:space="preserve"> XE "Verpflichteter"\f </w:instrText>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="end" />
                        </w:r>
                        <w:r>
                            <w:t>“ und gemeinsam die „</w:t>
                        </w:r>
                        <w:commentRangeStart w:id="2" />
                        <w:r w:rsidRPr="00E62F86">
                            <w:rPr>
                                <w:rFonts w:asciiTheme="majorHAnsi" w:hAnsiTheme="majorHAnsi" />
                            </w:rPr>
                            <w:t>Verpflichteten</w:t>
                        </w:r>
                        <w:commentRangeEnd w:id="2" />
                        <w:r>
                            <w:rPr>
                                <w:rStyle w:val="Kommentarzeichen" />
                            </w:rPr>
                            <w:commentReference w:id="2" />
                        </w:r>
                        <w:r>
                            <w:rPr>
                                <w:bCs />
                            </w:rPr>
                            <w:fldChar w:fldCharType="begin" />
                        </w:r>
                        <w:r>
                            <w:rPr>
                                <w:bCs />
                            </w:rPr>
                            <w:instrText xml:space="preserve"> XE "Verpflichteten"\f </w:instrText>
                        </w:r>
                        <w:r>
                            <w:rPr>
                                <w:bCs />
                            </w:rPr>
                            <w:fldChar w:fldCharType="end" />
                        </w:r>
                        <w:r>
                            <w:t xml:space="preserve">“), für die Dauer von </w:t>
                        </w:r>
                        <w:r>
                            <w:rPr>
                                <w:color w:val="008FA0" />
                            </w:rPr>
                            <w:t>zwei (2) Jahren</w:t>
                        </w:r>
                        <w:r>
                            <w:t xml:space="preserve"> ab dem Abschluss dieses Vertrags, jegliche Betätigung zu unterlassen, mit der der jeweilige Verpflichtete in Wettbewerb zur Geschäftstätigkeit der Zielgesellschaft, wie sie in Ziffer </w:t>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="begin" />
                        </w:r>
                        <w:r>
                            <w:instrText xml:space="preserve"> REF _Ref793594583 \r \h </w:instrText>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="separate" />
                        </w:r>
                        <w:r>
                            <w:t>1.3</w:t>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="end" />
                        </w:r>
                        <w:r>
                            <w:t xml:space="preserve"> beschrieben wird, treten würden. Jeder Verpflichtete wird insbesondere kein Unternehmen, welches im vorstehenden Sinne im Wettbewerb zur Zielgesellschaft steht, unmittelbar oder mittelbar gründen, erwerben, sich daran beteiligen oder für ein solches Unternehmen tätig werden, sei es in geschäftsführender, beratender oder sonstiger Funktion. Dieses Wettbewerbsverbot gilt für das Gebiet der Bundesrepublik Deutschland.</w:t>
                        </w:r>
                        <w:bookmarkEnd w:id="0" />
                    </w:p>
                    <w:p w14:paraId="00DB1FBF" w14:textId="77777777" w:rsidR="00000000"
                        w:rsidRDefault="005A0522" />
                    <w:sectPr w:rsidR="00000000">
                        <w:pgSz w:w="12240" w:h="15840" />
                        <w:pgMar w:top="1417" w:right="1417" w:bottom="1134" w:left="1417"
                            w:header="720" w:footer="720" w:gutter="0" />
                        <w:cols w:space="720" />
                    </w:sectPr>
                </w:body>
            </w:document>
        </pkg:xmlData>
    </pkg:part>
    <pkg:part pkg:name="/word/comments.xml"
        pkg:contentType="application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml">
        <pkg:xmlData>
            <w:comments
                xmlns:wpc="http://schemas.microsoft.com/office/word/2010/wordprocessingCanvas"
                xmlns:cx="http://schemas.microsoft.com/office/drawing/2014/chartex"
                xmlns:cx1="http://schemas.microsoft.com/office/drawing/2015/9/8/chartex"
                xmlns:cx2="http://schemas.microsoft.com/office/drawing/2015/10/21/chartex"
                xmlns:cx3="http://schemas.microsoft.com/office/drawing/2016/5/9/chartex"
                xmlns:cx4="http://schemas.microsoft.com/office/drawing/2016/5/10/chartex"
                xmlns:cx5="http://schemas.microsoft.com/office/drawing/2016/5/11/chartex"
                xmlns:cx6="http://schemas.microsoft.com/office/drawing/2016/5/12/chartex"
                xmlns:cx7="http://schemas.microsoft.com/office/drawing/2016/5/13/chartex"
                xmlns:cx8="http://schemas.microsoft.com/office/drawing/2016/5/14/chartex"
                xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006"
                xmlns:aink="http://schemas.microsoft.com/office/drawing/2016/ink"
                xmlns:am3d="http://schemas.microsoft.com/office/drawing/2017/model3d"
                xmlns:o="urn:schemas-microsoft-com:office:office"
                xmlns:oel="http://schemas.microsoft.com/office/2019/extlst"
                xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships"
                xmlns:m="http://schemas.openxmlformats.org/officeDocument/2006/math"
                xmlns:v="urn:schemas-microsoft-com:vml"
                xmlns:wp14="http://schemas.microsoft.com/office/word/2010/wordprocessingDrawing"
                xmlns:wp="http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing"
                xmlns:w10="urn:schemas-microsoft-com:office:word"
                xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main"
                xmlns:w14="http://schemas.microsoft.com/office/word/2010/wordml"
                xmlns:w15="http://schemas.microsoft.com/office/word/2012/wordml"
                xmlns:w16cex="http://schemas.microsoft.com/office/word/2018/wordml/cex"
                xmlns:w16cid="http://schemas.microsoft.com/office/word/2016/wordml/cid"
                xmlns:w16="http://schemas.microsoft.com/office/word/2018/wordml"
                xmlns:w16sdtdh="http://schemas.microsoft.com/office/word/2020/wordml/sdtdatahash"
                xmlns:w16se="http://schemas.microsoft.com/office/word/2015/wordml/symex"
                xmlns:wpg="http://schemas.microsoft.com/office/word/2010/wordprocessingGroup"
                xmlns:wpi="http://schemas.microsoft.com/office/word/2010/wordprocessingInk"
                xmlns:wne="http://schemas.microsoft.com/office/word/2006/wordml"
                xmlns:wps="http://schemas.microsoft.com/office/word/2010/wordprocessingShape"
                mc:Ignorable="w14 w15 w16se w16cid w16 w16cex w16sdtdh wp14">
                <w:comment w:id="1" w:author="Alber, Franziska" w:date="2023-04-25T15:08:00Z"
                    w:initials="AF">
                    <w:p w14:paraId="24858DFA" w14:textId="77777777" w:rsidR="005A0522"
                        w:rsidRDefault="005A0522">
                        <w:pPr>
                            <w:pStyle w:val="Kommentartext" />
                        </w:pPr>
                        <w:r>
                            <w:rPr>
                                <w:rStyle w:val="Kommentarzeichen" />
                            </w:rPr>
                            <w:annotationRef />
                        </w:r>
                        <w:r>
                            <w:t>Falls die Verkäufer juristische Personen sind, sollten auch die
                                Verkäufergesellschafter als natürliche Personen dahinter in das
                                Wettbewerbsverbot mitreingenommen werden.</w:t>
                        </w:r>
                    </w:p>
                </w:comment>
                <w:comment w:id="2" w:author="Mehler, Fritz" w:date="2023-08-10T08:02:00Z"
                    w:initials="MF">
                    <w:p w14:paraId="32A4768E" w14:textId="77777777" w:rsidR="005A0522"
                        w:rsidRDefault="005A0522">
                        <w:pPr>
                            <w:pStyle w:val="Kommentartext" />
                        </w:pPr>
                        <w:r>
                            <w:rPr>
                                <w:rStyle w:val="Kommentarzeichen" />
                            </w:rPr>
                            <w:annotationRef />
                        </w:r>
                        <w:r>
                            <w:t>Wird definiert aber nicht verwendet</w:t>
                        </w:r>
                    </w:p>
                </w:comment>
            </w:comments>
        </pkg:xmlData>
    </pkg:part>
</pkg:package>`;
const xmlWithCommentAndTermDef = `<?xml version="1.0" standalone="yes"?>
<?mso-application progid="Word.Document"?>
<pkg:package xmlns:pkg="http://schemas.microsoft.com/office/2006/xmlPackage">
    <pkg:part pkg:name="/_rels/.rels"
        pkg:contentType="application/vnd.openxmlformats-package.relationships+xml" pkg:padding="512">
        <pkg:xmlData>
            <Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships">
                <Relationship Id="selectedAnswers"
                    Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/json"
                    Target="lawlift/selectedAnswers.json" />
                <Relationship Id="document"
                    Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/json"
                    Target="lawlift/document.json" />
                <Relationship Id="rId1"
                    Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument"
                    Target="word/document.xml" />
            </Relationships>
        </pkg:xmlData>
    </pkg:part>
    <pkg:part pkg:name="/word/document.xml"
        pkg:contentType="application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml">
        <pkg:xmlData>
            <w:document
                xmlns:wpc="http://schemas.microsoft.com/office/word/2010/wordprocessingCanvas"
                xmlns:cx="http://schemas.microsoft.com/office/drawing/2014/chartex"
                xmlns:cx1="http://schemas.microsoft.com/office/drawing/2015/9/8/chartex"
                xmlns:cx2="http://schemas.microsoft.com/office/drawing/2015/10/21/chartex"
                xmlns:cx3="http://schemas.microsoft.com/office/drawing/2016/5/9/chartex"
                xmlns:cx4="http://schemas.microsoft.com/office/drawing/2016/5/10/chartex"
                xmlns:cx5="http://schemas.microsoft.com/office/drawing/2016/5/11/chartex"
                xmlns:cx6="http://schemas.microsoft.com/office/drawing/2016/5/12/chartex"
                xmlns:cx7="http://schemas.microsoft.com/office/drawing/2016/5/13/chartex"
                xmlns:cx8="http://schemas.microsoft.com/office/drawing/2016/5/14/chartex"
                xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006"
                xmlns:aink="http://schemas.microsoft.com/office/drawing/2016/ink"
                xmlns:am3d="http://schemas.microsoft.com/office/drawing/2017/model3d"
                xmlns:o="urn:schemas-microsoft-com:office:office"
                xmlns:oel="http://schemas.microsoft.com/office/2019/extlst"
                xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships"
                xmlns:m="http://schemas.openxmlformats.org/officeDocument/2006/math"
                xmlns:v="urn:schemas-microsoft-com:vml"
                xmlns:wp14="http://schemas.microsoft.com/office/word/2010/wordprocessingDrawing"
                xmlns:wp="http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing"
                xmlns:w10="urn:schemas-microsoft-com:office:word"
                xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main"
                xmlns:w14="http://schemas.microsoft.com/office/word/2010/wordml"
                xmlns:w15="http://schemas.microsoft.com/office/word/2012/wordml"
                xmlns:w16cex="http://schemas.microsoft.com/office/word/2018/wordml/cex"
                xmlns:w16cid="http://schemas.microsoft.com/office/word/2016/wordml/cid"
                xmlns:w16="http://schemas.microsoft.com/office/word/2018/wordml"
                xmlns:w16sdtdh="http://schemas.microsoft.com/office/word/2020/wordml/sdtdatahash"
                xmlns:w16se="http://schemas.microsoft.com/office/word/2015/wordml/symex"
                xmlns:wpg="http://schemas.microsoft.com/office/word/2010/wordprocessingGroup"
                xmlns:wpi="http://schemas.microsoft.com/office/word/2010/wordprocessingInk"
                xmlns:wne="http://schemas.microsoft.com/office/word/2006/wordml"
                xmlns:wps="http://schemas.microsoft.com/office/word/2010/wordprocessingShape"
                mc:Ignorable="w14 w15 w16se w16cid w16 w16cex w16sdtdh wp14">
                <w:body>
                    <w:p w14:paraId="424FD7E8" w14:textId="77777777" w:rsidR="00432B40"
                        w:rsidRDefault="00432B40" w:rsidP="00432B40">
                        <w:pPr>
                            <w:pStyle w:val="ESLegal2" />
                            <w:suppressAutoHyphens />
                        </w:pPr>
                        <w:bookmarkStart w:id="0" w:name="_Ref450615844" />
                        <w:r>
                            <w:rPr>
                                <w:color w:val="008FA0" />
                            </w:rPr>
                            <w:t>Die Verkäufer</w:t>
                        </w:r>
                        <w:r>
                            <w:t xml:space="preserve"> </w:t>
                        </w:r>
                        <w:commentRangeStart w:id="1" />
                        <w:r>
                            <w:t xml:space="preserve">und die Verkäufergesellschafter </w:t>
                        </w:r>
                        <w:commentRangeEnd w:id="1" />
                        <w:r>
                            <w:rPr>
                                <w:rStyle w:val="Kommentarzeichen" />
                            </w:rPr>
                            <w:commentReference w:id="1" />
                        </w:r>
                        <w:r>
                            <w:t>verpflichten sich, jeweils unabhängig und jeder für sich
                                (nachfolgen jeweils einzeln ein „</w:t>
                        </w:r>
                        <w:r w:rsidRPr="00BA2B92">
                            <w:rPr>
                                <w:rFonts w:asciiTheme="majorHAnsi" w:hAnsiTheme="majorHAnsi"
                                    w:cstheme="majorHAnsi" />
                            </w:rPr>
                            <w:t>Verpflichteter</w:t>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="begin" />
                        </w:r>
                        <w:r>
                            <w:instrText xml:space="preserve"> XE "Verpflichteter"\f </w:instrText>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="end" />
                        </w:r>
                        <w:r>
                            <w:t>“ und gemeinsam die „</w:t>
                        </w:r>
                        <w:r w:rsidRPr="00E62F86">
                            <w:rPr>
                                <w:rFonts w:asciiTheme="majorHAnsi" w:hAnsiTheme="majorHAnsi" />
                            </w:rPr>
                            <w:t>Verpflichteten</w:t>
                        </w:r>
                        <w:r>
                            <w:rPr>
                                <w:bCs />
                            </w:rPr>
                            <w:fldChar w:fldCharType="begin" />
                        </w:r>
                        <w:r>
                            <w:rPr>
                                <w:bCs />
                            </w:rPr>
                            <w:instrText xml:space="preserve"> XE "Verpflichteten"\f </w:instrText>
                        </w:r>
                        <w:r>
                            <w:rPr>
                                <w:bCs />
                            </w:rPr>
                            <w:fldChar w:fldCharType="end" />
                        </w:r>
                        <w:r>
                            <w:t xml:space="preserve">“), für die Dauer von </w:t>
                        </w:r>
                        <w:r>
                            <w:rPr>
                                <w:color w:val="008FA0" />
                            </w:rPr>
                            <w:t>zwei (2) Jahren</w:t>
                        </w:r>
                        <w:r>
                            <w:t xml:space="preserve"> ab dem Abschluss dieses Vertrags, jegliche Betätigung zu unterlassen, mit der der jeweilige Verpflichtete in Wettbewerb zur Geschäftstätigkeit der Zielgesellschaft, wie sie in Ziffer </w:t>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="begin" />
                        </w:r>
                        <w:r>
                            <w:instrText xml:space="preserve"> REF _Ref793594583 \r \h </w:instrText>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="separate" />
                        </w:r>
                        <w:r>
                            <w:t>1.3</w:t>
                        </w:r>
                        <w:r>
                            <w:fldChar w:fldCharType="end" />
                        </w:r>
                        <w:r>
                            <w:t xml:space="preserve"> beschrieben wird, treten würden. Jeder Verpflichtete wird insbesondere kein Unternehmen, welches im vorstehenden Sinne im Wettbewerb zur Zielgesellschaft steht, unmittelbar oder mittelbar gründen, erwerben, sich daran beteiligen oder für ein solches Unternehmen tätig werden, sei es in geschäftsführender, beratender oder sonstiger Funktion. Dieses Wettbewerbsverbot gilt für das Gebiet der Bundesrepublik Deutschland.</w:t>
                        </w:r>
                        <w:bookmarkEnd w:id="0" />
                    </w:p>
                    <w:p w14:paraId="01805878" w14:textId="77777777" w:rsidR="00000000"
                        w:rsidRDefault="00432B40" />
                    <w:sectPr w:rsidR="00000000">
                        <w:pgSz w:w="12240" w:h="15840" />
                        <w:pgMar w:top="1417" w:right="1417" w:bottom="1134" w:left="1417"
                            w:header="720" w:footer="720" w:gutter="0" />
                        <w:cols w:space="720" />
                    </w:sectPr>
                </w:body>
            </w:document>
        </pkg:xmlData>
    </pkg:part>
    <pkg:part pkg:name="/word/comments.xml"
        pkg:contentType="application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml">
        <pkg:xmlData>
            <w:comments
                xmlns:wpc="http://schemas.microsoft.com/office/word/2010/wordprocessingCanvas"
                xmlns:cx="http://schemas.microsoft.com/office/drawing/2014/chartex"
                xmlns:cx1="http://schemas.microsoft.com/office/drawing/2015/9/8/chartex"
                xmlns:cx2="http://schemas.microsoft.com/office/drawing/2015/10/21/chartex"
                xmlns:cx3="http://schemas.microsoft.com/office/drawing/2016/5/9/chartex"
                xmlns:cx4="http://schemas.microsoft.com/office/drawing/2016/5/10/chartex"
                xmlns:cx5="http://schemas.microsoft.com/office/drawing/2016/5/11/chartex"
                xmlns:cx6="http://schemas.microsoft.com/office/drawing/2016/5/12/chartex"
                xmlns:cx7="http://schemas.microsoft.com/office/drawing/2016/5/13/chartex"
                xmlns:cx8="http://schemas.microsoft.com/office/drawing/2016/5/14/chartex"
                xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006"
                xmlns:aink="http://schemas.microsoft.com/office/drawing/2016/ink"
                xmlns:am3d="http://schemas.microsoft.com/office/drawing/2017/model3d"
                xmlns:o="urn:schemas-microsoft-com:office:office"
                xmlns:oel="http://schemas.microsoft.com/office/2019/extlst"
                xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships"
                xmlns:m="http://schemas.openxmlformats.org/officeDocument/2006/math"
                xmlns:v="urn:schemas-microsoft-com:vml"
                xmlns:wp14="http://schemas.microsoft.com/office/word/2010/wordprocessingDrawing"
                xmlns:wp="http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing"
                xmlns:w10="urn:schemas-microsoft-com:office:word"
                xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main"
                xmlns:w14="http://schemas.microsoft.com/office/word/2010/wordml"
                xmlns:w15="http://schemas.microsoft.com/office/word/2012/wordml"
                xmlns:w16cex="http://schemas.microsoft.com/office/word/2018/wordml/cex"
                xmlns:w16cid="http://schemas.microsoft.com/office/word/2016/wordml/cid"
                xmlns:w16="http://schemas.microsoft.com/office/word/2018/wordml"
                xmlns:w16sdtdh="http://schemas.microsoft.com/office/word/2020/wordml/sdtdatahash"
                xmlns:w16se="http://schemas.microsoft.com/office/word/2015/wordml/symex"
                xmlns:wpg="http://schemas.microsoft.com/office/word/2010/wordprocessingGroup"
                xmlns:wpi="http://schemas.microsoft.com/office/word/2010/wordprocessingInk"
                xmlns:wne="http://schemas.microsoft.com/office/word/2006/wordml"
                xmlns:wps="http://schemas.microsoft.com/office/word/2010/wordprocessingShape"
                mc:Ignorable="w14 w15 w16se w16cid w16 w16cex w16sdtdh wp14">
                <w:comment w:id="1" w:author="Alber, Franziska" w:date="2023-04-25T15:08:00Z"
                    w:initials="AF">
                    <w:p w14:paraId="0C1AA6EB" w14:textId="77777777" w:rsidR="00432B40"
                        w:rsidRDefault="00432B40">
                        <w:pPr>
                            <w:pStyle w:val="Kommentartext" />
                        </w:pPr>
                        <w:r>
                            <w:rPr>
                                <w:rStyle w:val="Kommentarzeichen" />
                            </w:rPr>
                            <w:annotationRef />
                        </w:r>
                        <w:r>
                            <w:t>Falls die Verkäufer juristische Personen sind, sollten auch die
                                Verkäufergesellschafter als natürliche Personen dahinter in das
                                Wettbewerbsverbot mitreingenommen werden.</w:t>
                        </w:r>
                    </w:p>
                </w:comment>
            </w:comments>
        </pkg:xmlData>
    </pkg:part>
</pkg:package>`;
const xmlWithNoobHeadlinesAndFontsize = `<w:body>
<w:p
    w14:paraId="27FE5235"
    w14:textId="77777777"
    w:rsidR="00E6653B"
    w:rsidRPr="009265BE"
    w:rsidRDefault="00E6653B"
    w:rsidP="00E6653B">
    <w:pPr>
        <w:numPr>
            <w:ilvl w:val="0" />
            <w:numId w:val="23" />
        </w:numPr>
        <w:rPr>
            <w:b />
            <w:sz w:val="22" />
            <w:szCs w:val="22" />
        </w:rPr>
    </w:pPr>
    <w:r w:rsidRPr="009265BE">
        <w:rPr>
            <w:b />
            <w:sz w:val="22" />
            <w:szCs w:val="22" />
        </w:rPr>
        <w:t>Krankheit</w:t>
    </w:r>
</w:p>
<w:p
    w14:paraId="62A48DC0"
    w14:textId="4913CB6F"
    w:rsidR="00E6653B"
    w:rsidRDefault="00E6653B"
    w:rsidP="00E6653B">
    <w:pPr>
        <w:ind w:left="567" />
        <w:rPr>
            <w:sz w:val="22" />
            <w:szCs w:val="22" />
        </w:rPr>
    </w:pPr>
    <w:r>
        <w:rPr>
            <w:sz w:val="22" />
            <w:szCs w:val="22" />
        </w:rPr>
        <w:t xml:space="preserve"
        >Die Entgeltfortzahlung im Krankheitsfall richtet sich
  </w:t>
    </w:r>
    <w:r w:rsidRPr="009265BE">
        <w:rPr>
            <w:sz w:val="22" />
            <w:szCs w:val="22" />
        </w:rPr>
        <w:t xml:space="preserve"
        >nach den ‎gesetzlichen Bestimmungen. Die Arbeitsverhinderung ist dem
    Arbeitgeber unverzüglich ‎mitzuteilen. Dauert die Arbeitsunfähigkeit
    länger als drei Kalendertage, hat der Arbeitnehmer ‎eine ärztliche
    Bescheinigung über das Bestehen sowie deren voraussichtliche Dauer
    ‎spätestens an dem auf den dritten Kalendertag folgenden Arbeitstag
    vorzulegen. Diese ‎Nachweispflicht gilt auch nach Ablauf der sechs
    Wochen. Der Arbeitgeber ist berechtigt,
  </w:t>
    </w:r>
    <w:r>
        <w:rPr>
            <w:sz w:val="22" />
            <w:szCs w:val="22" />
        </w:rPr>
        <w:t xml:space="preserve">eine </w:t>
    </w:r>
    <w:commentRangeStart w:id="0" />
    <w:r>
        <w:rPr>
            <w:sz w:val="22" />
            <w:szCs w:val="22" />
        </w:rPr>
        <w:t>Mitteilung über Art und Ursache der Krankheit</w:t>
    </w:r>
    <w:commentRangeEnd w:id="0" />
    <w:r>
        <w:rPr>
            <w:rStyle w:val="Kommentarzeichen" />
        </w:rPr>
        <w:commentReference w:id="0" />
    </w:r>
    <w:r>
        <w:rPr>
            <w:sz w:val="22" />
            <w:szCs w:val="22" />
        </w:rPr>
        <w:t xml:space="preserve"> sowie </w:t>
    </w:r>
    <w:r w:rsidRPr="009265BE">
        <w:rPr>
            <w:sz w:val="22" />
            <w:szCs w:val="22" />
        </w:rPr>
        <w:t>die ‎Vorlage der Arbeitsunfähigkeitsbescheinigung früher zu
            verlangen.</w:t>
    </w:r>
    <w:r>
        <w:rPr>
            <w:sz w:val="22" />
            <w:szCs w:val="22" />
        </w:rPr>
        <w:t xml:space="preserve"> </w:t>
    </w:r>
</w:p>
<w:p
    w14:paraId="2F40E497"
    w14:textId="77777777"
    w:rsidR="00000000"
    w:rsidRDefault="00E6653B" />
<w:sectPr w:rsidR="00000000">
    <w:pgSz w:w="12240" w:h="15840" />
    <w:pgMar
        w:top="1417"
        w:right="1417"
        w:bottom="1134"
        w:left="1417"
        w:header="720"
        w:footer="720"
        w:gutter="0" />
    <w:cols w:space="720" />
</w:sectPr>
</w:body>
`;
const xmlWithManyNoobHeadlines = `<w:body><w:p w14:paraId="68506EE5" w14:textId="77777777" w:rsidR="00B425E2" w:rsidRDefault="00B425E2" w:rsidP="00B425E2"><w:pPr><w:numPr><w:ilvl w:val="0"/><w:numId w:val="23"/></w:numPr><w:rPr><w:b/><w:sz w:val="22"/><w:szCs w:val="22"/></w:rPr></w:pPr><w:r><w:rPr><w:b/><w:sz w:val="22"/><w:szCs w:val="22"/></w:rPr><w:t>Urlaub</w:t></w:r></w:p><w:p w14:paraId="70BB3E2D" w14:textId="77777777" w:rsidR="00B425E2" w:rsidRPr="008C3BA9" w:rsidRDefault="00B425E2" w:rsidP="00B425E2"><w:pPr><w:numPr><w:ilvl w:val="1"/><w:numId w:val="23"/></w:numPr><w:rPr><w:b/><w:sz w:val="22"/><w:szCs w:val="22"/></w:rPr></w:pPr><w:r><w:rPr><w:sz w:val="22"/><w:szCs w:val="22"/></w:rPr><w:t>Die</w:t></w:r><w:r w:rsidRPr="008C3BA9"><w:rPr><w:sz w:val="22"/><w:szCs w:val="22"/></w:rPr><w:t xml:space="preserve"> Arbeitnehmer</w:t></w:r><w:r><w:rPr><w:sz w:val="22"/><w:szCs w:val="22"/></w:rPr><w:t>in</w:t></w:r><w:r w:rsidRPr="008C3BA9"><w:rPr><w:sz w:val="22"/><w:szCs w:val="22"/></w:rPr><w:t xml:space="preserve"> hat Anspruch auf einen gesetzlichen Mindesturlaub von derzeit </w:t></w:r><w:commentRangeStart w:id="0"/><w:r w:rsidRPr="00626028"><w:rPr><w:sz w:val="22"/><w:szCs w:val="22"/><w:highlight w:val="yellow"/></w:rPr><w:t>25</w:t></w:r><w:r w:rsidRPr="008C3BA9"><w:rPr><w:sz w:val="22"/><w:szCs w:val="22"/></w:rPr><w:t xml:space="preserve"> </w:t></w:r><w:commentRangeEnd w:id="0"/><w:r><w:rPr><w:rStyle w:val="Kommentarzeichen"/></w:rPr><w:commentReference w:id="0"/></w:r><w:r w:rsidRPr="008C3BA9"><w:rPr><w:sz w:val="22"/><w:szCs w:val="22"/></w:rPr><w:t xml:space="preserve">‎Arbeitstagen im Kalenderjahr – ausgehend von einer Fünf-Tage-Woche. Der Arbeitgeber ‎gewährt zusätzlich einen vertraglichen Urlaub von weiteren </w:t></w:r><w:r><w:rPr><w:sz w:val="22"/><w:szCs w:val="22"/></w:rPr><w:t xml:space="preserve">10 </w:t></w:r><w:r w:rsidRPr="008C3BA9"><w:rPr><w:sz w:val="22"/><w:szCs w:val="22"/></w:rPr><w:t>Arbeitstagen. Bei der ‎Gewährung von Urlaub wird zuerst der gesetzliche Urlaub eingebracht.‎</w:t></w:r></w:p><w:p w14:paraId="5A4D2F45" w14:textId="77777777" w:rsidR="00B425E2" w:rsidRPr="0003156B" w:rsidRDefault="00B425E2" w:rsidP="00B425E2"><w:pPr><w:numPr><w:ilvl w:val="1"/><w:numId w:val="23"/></w:numPr><w:rPr><w:sz w:val="22"/><w:szCs w:val="22"/></w:rPr></w:pPr><w:r w:rsidRPr="0003156B"><w:rPr><w:sz w:val="22"/><w:szCs w:val="22"/></w:rPr><w:t>Bei Beendigung des Arbeitsverhältnisses</w:t></w:r><w:commentRangeStart w:id="1"/><w:r w:rsidRPr="0003156B" w:rsidDel="00980A2B"><w:rPr><w:sz w:val="22"/><w:szCs w:val="22"/></w:rPr><w:t xml:space="preserve"> </w:t></w:r><w:r w:rsidDel="00980A2B"><w:rPr><w:sz w:val="22"/><w:szCs w:val="22"/></w:rPr><w:t xml:space="preserve"> </w:t></w:r><w:r><w:rPr><w:sz w:val="22"/><w:szCs w:val="22"/></w:rPr><w:t xml:space="preserve"> </w:t></w:r><w:r w:rsidDel="00980A2B"><w:rPr><w:sz w:val="22"/><w:szCs w:val="22"/></w:rPr><w:t xml:space="preserve">  </w:t></w:r><w:commentRangeEnd w:id="1"/><w:r><w:rPr><w:rStyle w:val="Kommentarzeichen"/></w:rPr><w:commentReference w:id="1"/></w:r><w:r w:rsidRPr="0003156B"><w:rPr><w:sz w:val="22"/><w:szCs w:val="22"/></w:rPr><w:t>sind verbleibende Urlaubsansprüche innerhalb der ‎Kündigungsfrist abzubauen, soweit dies möglich ist. Der vertragliche Zusatzurlaub erlischt mit ‎Beendig</w:t></w:r><w:r><w:rPr><w:sz w:val="22"/><w:szCs w:val="22"/></w:rPr><w:t xml:space="preserve">ung des Arbeitsverhältnisses. </w:t></w:r></w:p><w:p w14:paraId="1BD20BA5" w14:textId="5E1B4BB2" w:rsidR="00000000" w:rsidRDefault="00B425E2" w:rsidP="00B425E2"><w:r w:rsidRPr="0003156B"><w:rPr><w:sz w:val="22"/><w:szCs w:val="22"/></w:rPr><w:t xml:space="preserve">Die rechtliche Behandlung des Urlaubs richtet sich im Übrigen nach den </w:t></w:r><w:r><w:rPr><w:sz w:val="22"/><w:szCs w:val="22"/></w:rPr><w:t>gesetzlichen Bestimmungen</w:t></w:r><w:r w:rsidRPr="0003156B"><w:rPr><w:sz w:val="22"/><w:szCs w:val="22"/></w:rPr><w:t>.‎</w:t></w:r></w:p><w:sectPr w:rsidR="00000000"><w:pgSz w:w="12240" w:h="15840"/><w:pgMar w:top="1417" w:right="1417" w:bottom="1134" w:left="1417" w:header="720" w:footer="720" w:gutter="0"/><w:cols w:space="720"/></w:sectPr></w:body>`;
test("read noob format", () => {
    const xmlO = new OOXML(xmlWithNoobHeadlinesAndFontsize);
    const r = xmlO.getContents();
    console.log("ok");
});
test("read 4", () => {
    const xmlO = new OOXML(xml4);
    const r = xmlO.getContents();
    console.log("ok");
});
test("read 3", () => {
    const xmlO = new OOXML(xml3);
    const r = xmlO.getContents();
    console.log("ok");
});
test("read 2", () => {
    const xmlO = new OOXML(xml2);
    const r = xmlO.getContents();
    console.log("ok");
    expect(true).toBe(true);
});
test("read 1", () => {
    const xmlO = new OOXML(xml);
    const r = xmlO.getContents();
    console.log("ok");
});
test("write", () => {
    const xmlO = new OOXML(xml);
    const r = xmlO.getXml();
    expect(r.match(/<w:p>/g).length).toBe(3);
    validateXML(r);
});
test.skip("write noob style 2", () => {
    const xmlO = new OOXML(xmlWithManyNoobHeadlines);
    const r = xmlO.getXml();
    expect(() => { validateXML(r); }).not.toThrow();
    expect(r).toContain("XE(Verpflichteter)");
    expect(r).toContain("CMNT( und die Verkäufergesellschafter , 1)");
});
test.skip("write noob style", () => {
    const xmlO = new OOXML(xmlWithNoobHeadlinesAndFontsize);
    const r = xmlO.getXml();
    expect(() => { validateXML(r); }).not.toThrow();
    expect(r).toContain("XE(Verpflichteter)");
    expect(r).toContain("CMNT( und die Verkäufergesellschafter , 1)");
});
test("correct whitespace after ref", () => {
    const xmlO = new OOXML(`<w:body><w:p w14:paraId="7BDCA40D" w14:textId="77777777" w:rsidR="002C5078" w:rsidRDefault="002C5078" w:rsidP="00E62F86"><w:pPr><w:pStyle w:val="ESLegal2"/><w:suppressAutoHyphens/></w:pPr><w:r><w:rPr><w:color w:val="008FA0"/></w:rPr><w:t>Haben die Verkäufer</w:t></w:r><w:r><w:t xml:space="preserve"> eine Verhaltenspflicht nach Ziffer </w:t></w:r><w:r><w:fldChar w:fldCharType="begin"/></w:r><w:r><w:instrText xml:space="preserve"> REF _Ref307914069 \r \h </w:instrText></w:r><w:r><w:fldChar w:fldCharType="separate"/></w:r><w:r><w:t>8</w:t></w:r><w:r><w:fldChar w:fldCharType="end"/></w:r><w:r><w:t xml:space="preserve"> verletzt, richten sich die Rechtsfolgen nach Ziffer </w:t></w:r><w:r><w:fldChar w:fldCharType="begin"/></w:r><w:r><w:instrText xml:space="preserve"> REF _Ref344476666 \r \h </w:instrText></w:r><w:r><w:fldChar w:fldCharType="separate"/></w:r><w:r><w:t>6</w:t></w:r><w:r><w:fldChar w:fldCharType="end"/></w:r><w:r><w:t>, welche entsprechende Anwendung findet.</w:t></w:r></w:p><w:p w14:paraId="2D75BFCC" w14:textId="77777777" w:rsidR="00000000" w:rsidRDefault="002C5078"/><w:sectPr w:rsidR="00000000"><w:pgSz w:w="12240" w:h="15840"/><w:pgMar w:top="1417" w:right="1417" w:bottom="1134" w:left="1417" w:header="720" w:footer="720" w:gutter="0"/><w:cols w:space="720"/></w:sectPr></w:body>`);
    const r = xmlO.getContents();
    expect(r).toContain("_Ref344476666(6),");
    const x = xmlO.getXml();
    expect(x).toContain(`<w:t xml:space="preserve">Ziffer&#xa0;</w:t></w:r>\n<w:r><w:fldChar w:fldCharType="separate"/></w:r>\n<w:fldSimple w:instr=" REF  _Ref344476666 \\n ">\n<w:r><w:t xml:space="preserve">6</w:t></w:r>\n</w:fldSimple>\n<w:r><w:t xml:space="preserve">, welche`);
    console.log(x);
});
test("read ref on second pass 2", () => {
    const xmlO = new OOXML(`<w:body><w:p w14:paraId="585EBF3A" w14:textId="77777777" w:rsidR="00415430" w:rsidRDefault="00415430" w:rsidP="00E62F86"><w:pPr><w:pStyle w:val="ESLegal3"/><w:suppressAutoHyphens/></w:pPr><w:r><w:t>Ansprüche des Käufers gemäß dieser Ziffer </w:t></w:r><w:r><w:fldChar w:fldCharType="begin"/></w:r><w:r><w:instrText xml:space="preserve"> REF _Ref462596241 \r \h </w:instrText></w:r><w:r><w:fldChar w:fldCharType="separate"/></w:r><w:r><w:t>9</w:t></w:r><w:r><w:fldChar w:fldCharType="end"/></w:r><w:r><w:t xml:space="preserve"> sind auf die Höhe des zahlbaren Kaufpreises beschränkt.</w:t></w:r></w:p><w:p w14:paraId="70D63BAE" w14:textId="77777777" w:rsidR="00000000" w:rsidRDefault="00415430"/><w:sectPr w:rsidR="00000000"><w:pgSz w:w="12240" w:h="15840"/><w:pgMar w:top="1417" w:right="1417" w:bottom="1134" w:left="1417" w:header="720" w:footer="720" w:gutter="0"/><w:cols w:space="720"/></w:sectPr></w:body>`);
    const r = xmlO.getContents();
    expect(r).toContain("Ziffer _Ref462596241(9) ");
    const xml = xmlO.getXml();
    const xmlO1 = new OOXML(xml);
    const r1 = xmlO1.getContents();
    console.log("");
});
test("second pass", () => {
    const xml0 = new OOXML(`<w:body><w:p w14:paraId="13EBFED2" w14:textId="77777777" w:rsidR="00A22612" w:rsidRDefault="00A22612" w:rsidP="00E62F86"><w:pPr><w:pStyle w:val="ESLegal3"/><w:suppressAutoHyphens/></w:pPr><w:r><w:t>Verträge mit den Kunden im Sinne von Ziffer </w:t></w:r><w:fldSimple w:instr=" REF  _Ref133322414 \n "><w:r><w:t>7.2.3.8</w:t></w:r></w:fldSimple><w:r><w:t>;</w:t></w:r></w:p><w:p w14:paraId="779A9397" w14:textId="77777777" w:rsidR="00000000" w:rsidRDefault="00A22612"/><w:sectPr w:rsidR="00000000"><w:pgSz w:w="12240" w:h="15840"/><w:pgMar w:top="1417" w:right="1417" w:bottom="1134" w:left="1417" w:header="720" w:footer="720" w:gutter="0"/><w:cols w:space="720"/></w:sectPr></w:body>`);
    const r0 = xml0.getContents();
    const xml1str = xml0.getXml();
    const xml1 = new OOXML(xml1str);
    const r1 = xml1.getContents();
    console.log("ok");
});
test("read ref on second pass", () => {
    const xmlO = new OOXML(`<w:body><w:p w14:paraId="4AEAB968" w14:textId="77777777" w:rsidR="00EA6BF5" w:rsidRDefault="00EA6BF5" w:rsidP="00E62F86"><w:pPr><w:pStyle w:val="ESLegal3"/><w:suppressAutoHyphens/></w:pPr><w:r><w:t>sofern und soweit der Käufer gegen in dieser Ziffer </w:t></w:r><w:fldSimple w:instr=" REF  _Ref462596241 \n "><w:r><w:t xml:space="preserve">9 </w:t></w:r></w:fldSimple><w:r><w:t>niedergelegte Pflichten verstoßen hat und sich dieser Verstoß in der Existenz oder der konkreten Höhe der Freistellungsfähigen Steuer niedergeschlagen hat.</w:t></w:r></w:p><w:p w14:paraId="69322036" w14:textId="77777777" w:rsidR="00000000" w:rsidRDefault="00EA6BF5"/><w:sectPr w:rsidR="00000000"><w:pgSz w:w="12240" w:h="15840"/><w:pgMar w:top="1417" w:right="1417" w:bottom="1134" w:left="1417" w:header="720" w:footer="720" w:gutter="0"/><w:cols w:space="720"/></w:sectPr></w:body>`);
    const r = xmlO.getContents();
    expect(r).toMatch(/Ziffer\s_Ref462596241\(9\) /);
});
test("read comments and term def", () => {
    const xmlO = new OOXML(xmlWithCommentAndTermDef);
    const r = xmlO.getContents();
    expect(r).toContain("XE(Verpflichteter)");
    expect(r).toContain("CMNT(und die Verkäufergesellschafter, 1)");
});
test("write comments and term def", () => {
    const xmlO = new OOXML(xmlWithCommentAndTermDef);
    const r = xmlO.getXml();
    validateXML(r);
});
function validateXML(xmlStr) {
    const result = XMLValidator.validate(xmlStr, {
    // unpairedTags: ["extra"]
    });
    console.log(result);
    if (result !== true) {
        throw (result);
    }
}
